( \* _日本語版は英語版の後にあります。_ )

# **GakuNin RDM Storage Downloader/Uploader**

This software consists of Python scripts to download data files from a storage mounted onto a GakuNin RDM project to a local folder or to upload in the opposite direction.

Click **[here](https://dmsutil.riken.jp/tool/grdm_storsync-0.1.1.zip)** to get the software package.
<br>
<br>

## **Setup**

### <u>Install Software</u>

Prepare a folder for this software and unpack the downloaded ZIP file as follows for Linux.
```shell
> unzip -d {PATH_TO_INSTALL_DIRECTORY} grdm_storsync-0.1.1.zip
```
For Windows, right-click on the ZIP file in File Explorer and select "Extract All" from the context menu.

The following files will appear.
```
README.md
dotenv_template_nii
dotenv_template_riken
downloader.py
grdm_stordl.py
grdm_storls.py
grdm_storul.py
settings.py
storlist.py
uploader.py
wbclient/__init__.py
wbclient/exceptions.py
wbclient/settings.py
wbclient/upload.py
```

### <u>Update Python</u>

This software requires the **<span style="color:red">3.10 or a higher version</span>** of `Python`. Confirm the version of `Python` in your environment.
```shell
> python --version
```
Update `Python` if this is not the case. Note that you may need root or sudo privileges. 

### <u>Install Depending Libraries</u>

The third-party Python modules, `requests` and `pydantic-settings`, are required. You can see if they have been installed or not in your environment in the following manner. 

For Linux:
```shell
> pip list | grep -e requests -e pydantic-settings
```
For Windows: (Use powershell)
```shell
> pip list | findstr "pydantic-settings requests"
```

The module names and versions will be shown if they are available. You may be able to install them, for example, as shown below. Note that you may need root or sudo privileges.
```shell
> pip install requests
> pip install pydantic-settings
```

### <u>Create Config File</u>

Prepare a config file with user settings. Edit a `.env` file like below by the vi editor, etc.
```shell
GRDM_ACCESS_TOKEN="ABCDEFGHIJKLM0123456789NOPQRSTUVWXYZ"
GRDM_OSFAPI_BASEURL="https://api.rdm.nii.ac.jp/v2/"
GRDM_WBAPI_BASEURL="https://files.rdm.nii.ac.jp/"
GRDM_PROJECT_ID="xyz01"
GRDM_STORAGE_PROVIDER="osfstorage"
GRDM_MOUNT_POINT="/home/user/mnt_dir"
```
&nbsp;<span style="background-color:#3cb371">Notes:</span>
- Set the file name as `.env` and put it in your current folder.
- The following 6 environment variables are mandatory in this software.

  <div style="background-color:rgba(240,255,255,0.05)">

  |Environment Variables|Description|
  |:--|:--|
  |GRDM_ACCESS_TOKEN|Personal access token set by the user at the GakuNin RDM.|
  |GRDM_OSFAPI_BASEURL|Base URL of OSF API at the GakuNin RDM.|
  |GRDM_WBAPI_BASEURL|Base URL of WaterButler API at the GakuNin RDM.|
  |GRDM_PROJECT_ID|5-digit ID of the GakuNin RDM project.|
  |GRDM_STORAGE_PROVIDER|Name of the GakuNin RDM storage where download/upload targets are stored.|
  |GRDM_MOUNT_POINT|Mount point, i.e. local folder path where download/upload target are stored.|

  - See **[this link](#config-detail)** for more details.
  - If you don't know the correct value for `GRDM_STORAGE_PROVIDER`, see **[this link](#storage-provider)**.
  - `GRDM_MOUNT_POINT` may be omitted only when you specify the mount point in the command-line option.
  - Use double-backslash ("\\\\") instead of single-backslash ("\\") in the Windows path.
  - If you can not create `.env` file in your current folder for some reason, you can prepare your settings in any file and indicate its path at the command-line argument when running this software scripts.
  
  </div>

<br>

## **Downloader: Download Data From GakuNin RDM Storage To Local**

Run the downloader script `grdm_stordl.py` as follows.
```shell
> python grdm_stordl.py {config-file path} -mp {mount point} -y
```
&nbsp;<span style="background-color:#3cb371">Notes:</span>
- If you run this command somewhere other than in the software folder, indicate the full/relative path to `grdm_stordl.py`.
- The `config-file path` can be omitted. If omitted, the `.env` file in the current folder will be read. (If not found, the `.env` file in the software folder will be used instead.)
- The settings in the config-file indicated at the command-line argument have the highest priority.
- The `mount point` specified by `-mp` option will override any other mount point settings in config files (including `.env`).
- Note that the mount point folder must exist and be empty when running this command. 
- The `-y` option assumes "yes" as answer to all prompts and runs non-interactively.

<br>

During running the downloader script, you will see a summary of download parameters as shown below in the standard output. If everything is OK, input **yes** to proceed the download process.
```
--------------------------------------------------------------------------
Data files will be downloaded from GakuNin RDM storage.
  GakuNin RDM project ID       : xyz01
  From (Remote storage folder) : /osfstorage/
  To (Local folder)            : /home/user/mnt_dir
--------------------------------------------------------------------------
Do you really want to proceed? [yes/no]
```

<br>

## **Uploader: Upload Data From Local To GakuNin RDM Storage**

Run the uploader script `grdm_storul.py` as follows.
```shell
> python grdm_storul.py {config-file path} -mp {mount point} -y
```
&nbsp;<span style="background-color:#3cb371">Notes:</span>
- If you run this command somewhere other than in the software folder, indicate the full/relative path to `grdm_storul.py`.
- The `config-file path` can be omitted. If omitted, the `.env` file in the current folder will be read. (If not found, the `.env` file in the software folder will be used instead.)
- The settings in the config-file indicated at the command-line argument have the highest priority.
- The `mount point` specified by the `-mp` option will override any other mount point settings in config files (including `.env`). 
- The `-y` option assumes "yes" as answer to all prompts and runs non-interactively.

<br>

During running the uploader script, you will see a summary of upload parameters as shown below in the standard output. If everything is OK, input **yes** to proceed the upload process.
```
--------------------------------------------------------------------------
Data files will be uploaded to GakuNin RDM storage.
  GakuNin RDM project ID     : xyz01
  From (Local folder)        : /home/user/mnt_dir
  To (Remote storage folder) : /osfstorage/20241231_235959
  * Note: A new remote folder will be created and local files will uploaded there. [GRDM_UPLOAD_REPLACE_FLAG=0]
  * Note: Local files will be kept after uploading. [GRDM_LOCAL_DELETE_FLAG=FALSE]
--------------------------------------------------------------------------
Do you really want to proceed? [yes/no]
```
&nbsp;<span style="background-color:#3cb371">Notes:</span>
- See **[this link](#config-detail)** for flags.
- The data under the target folder in the GakuNin RDM storage will not be replaced by uploaded local data in default. Instead, a new folder (named by uploading date and time, like "20241231_235959") will be created under the target folder and local data will be uploaded there. If you really need to replace the original data in the GakuNin RDM storage, set `GRDM_UPLOAD_REPLACE_FLAG` to **1** or **2**. Note that `GRDM_UPLOAD_REPLACE_FLAG` = **1** will replace all the original files in the GRDM storage by the uploaded even though the contents of the original and the uploaded are the same. 
- The data under the local folder will be kept there after uploading in default. If you would like to automatically delete them after uploading, set `GRDM_LOCAL_DELETE_FLAG` to **TRUE**.

<br>

## **Appendix**

<a id="config-detail"></a>
### <u>Config File and Setting Parameters</u>

A config file includes user settings for downloading/uploading. Basically a user should create `.env` file in the current folder and set environment variables in the file. The priority of user settings is defined as shown below. 

1. Settings in the file indicated at the command-line argument.
2. Settings in the `.env` file.
3. OS environment variables.
- If `.env` file in the current folder is not found, another `.env` file in the software folder (\*) will be used if available. (\* the folder under which this software package has been unpacked.)
- A JSON formatted file will also be accepted. The file extension must be ".json" and you have to indicate its path at the command-line argument when running this software. All keys must be written in lowercase in the JSON file.

The following table shows setting parameters to be accepted in this software. Note that these parameters are shared by the other software (GakuNin RDM Storage Mounter) and some of them are not used in this software.  

<div style="background-color:rgba(240,255,255,0.05)">

  |Parameters (Env. Variables)|Type|Description|
  |:--|:--|:--|
  |GRDM_ACCESS_TOKEN|str|Personal access token set by the user at the GakuNin RDM.|
  |GRDM_OSFAPI_BASEURL|str|Base URL of OSF API at the GakuNin RDM.|
  |GRDM_WBAPI_BASEURL|str|Base URL of WaterButler API at the GakuNin RDM.|
  |GRDM_PROJECT_ID|str|5-digit ID of the GakuNin RDM project.|
  |GRDM_STORAGE_PROVIDER|str|Name of the GakuNin RDM storage where download/upload targets are stored.|
  |GRDM_MOUNT_POINT|str|Mount point, i.e. local folder path where download/upload target are stored.|
  |GRDM_TARGET_FOLDER|str|Folder path in the GakuNin RDM storage where download/upload targets are stored. [default="/" (Top of storage)]|
  |GRDM_UPLOAD_CONCURRENT|int|Number of concurrent connections when uploading. [default=10]|
  |GRDM_UPLOAD_REPLACE_FLAG|int|If set to 1 or 2, the original data in the GakuNin RDM storage will be replaced when uploading. (0: not replaced / 1: forced to be replaced 2: Only added & updated contents will be replaced) [default=0 (Not replaced)]|
  |GRDM_LOCAL_DELETE_FLAG|bool|If TRUE, the local data will be deleted after uploading. [default=FALSE (Not deleted)]|
  |GRDM_INTERACTIVE_FLAG|bool|If FALSE, the process will proceed without asking the user whether to go or not. [default=TRUE (runs interactively)]|
  |GRDM_OUT_LOG|str|(\* Not used in this software) File path where log messages will be output.|

  - `GRDM_TARGET_FOLDER` must be the full path including the storage's top folder ("/").
  - If `GRDM_UPLOAD_REPLACE_FLAG` is set to 0, a new folder (named by uploading date and time, like "20241231_235959") will be created under the target folder in the GakuNin RDM storage and the local data will be uploaded to the created folder. 
  - Parameters without the default value in the above table (except for `GRDM_OUT_LOG`) will be treated as `None` in this software if not specified by the user, and will result in an error when running the downloader or uploader scripts.
  
  </div>

<br>

<a id="storage-provider"></a>
### <u>Storage Provider Name</u>

If you don't know the correct value for `GRDM_STORAGE_PROVIDER`、use the Python script `grdm_storls.py` bundled with this software as shown below. You will see a list of provider names of storages mounted to the GakuNin RDM project you specified by `GRDM_PROJECT_ID`. Set one of them to `GRDM_STORAGE_PROVIDER`.
```shell
> python3 grdm_storls.py {config-file path} -p {project ID}
```
&nbsp;<span style="background-color:#3cb371">Notes:</span>
- The mandatory environment variables for this script are only `GRDM_ACCESS_TOKEN`, `GRDM_OSFAPI_BASEURL`, and `GRDM_PROJECT_ID`.
- If you run this command somewhere other than in the software folder, indicate the path to `grdm_storls.py`.
- The `config-file path` can be omitted. If omitted, the `.env` file in the current folder will be read. (If not found, the `.env` file in the software folder will be used instead.)
- The settings in the config-file indicated at the command-line argument have the highest priority.
- The `project ID` specified by `-p` option will override any other project ID settings in config files (including `.env`). 


<br>
<br>
<br>
<br>

( \* _Scroll up for English version._ )

# **GakuNin RDMストレージダウンローダー/アップローダー**

本ソフトウェアは、GakuNin RDMのプロジェクトにマウントされたストレージ上のデータに関して、ローカルの環境にダウンロードもしくはローカルの環境からアップロードするためのPythonスクリプトです。

本ソフトウェアのパッケージは **[ここ](https://dmsutil.riken.jp/tool/grdm_storsync-0.1.1.zip)** からダウンロードしてください。
<br>
<br>

## **準備**

### <u>本ソフトウェアのインストール</u>

本ソフトウェアを格納するフォルダを準備して、ダウンロードしたパッケージ（ZIPファイル）を解凍・展開してください。Linuxでは以下のようにします。
```shell
> unzip -d {展開先のディレクトリパス} grdm_storsync-0.1.1.zip
```
Windowsの場合は、エクスプローラーでZIPファイルを右クリックして、メニューから「すべて展開」を選択してください。

展開すると、以下のようなファイルが作成されます。
```
README.md
dotenv_template_nii
dotenv_template_riken
downloader.py
grdm_stordl.py
grdm_storls.py
grdm_storul.py
settings.py
storlist.py
uploader.py
wbclient/__init__.py
wbclient/exceptions.py
wbclient/settings.py
wbclient/upload.py
```

### <u>Pythonのアップデート</u>

本ソフトウェアでは **<span style="color:red">バージョン3.10以上</span>** の `Python` が必要です。以下のように作業環境のバージョンを確認してください。
```shell
> python --version
```
もし、`Python` のバージョンが低い場合はアップデートしてください。(※環境によっては管理者権限が必要かもしれません)


### <u>依存パッケージのインストール</u>

本ソフトウェアでは、Pythonの標準ライブラリの他に、サードパーティ製のモジュールである `requests` および `pydantic-settings` が必要です。Linuxでは以下のようにすると、これらのモジュールが作業環境で利用できる場合は、その名称とバージョンが表示されます。
```shell
> pip list | grep -e requests -e pydantic-settings
```
Windowsの場合は、Powershellを立ち上げて、以下のように確認してください。
```shell
> pip list | findstr "pydantic-settings requests"
```
もし、これらのモジュールが無い場合は、以下のようにインストールしてください。(※環境によっては管理者権限が必要かもしれません)
```shell
> pip install requests
> pip install pydantic-settings
```


### <u>Configファイルの作成</u>

ユーザごとの設定を記述したConfigファイルを作成します。適当なエディタを使って、以下のような `.env` ファイルを作成してください。
```shell
GRDM_ACCESS_TOKEN="ABCDEFGHIJKLM0123456789NOPQRSTUVWXYZ"
GRDM_OSFAPI_BASEURL="https://api.rdm.nii.ac.jp/v2/"
GRDM_WBAPI_BASEURL="https://files.rdm.nii.ac.jp/"
GRDM_PROJECT_ID="xyz01"
GRDM_STORAGE_PROVIDER="osfstorage"
GRDM_MOUNT_POINT="/home/user/mnt_dir"
```
&nbsp;<span style="background-color:#3cb371">注意</span>
- ファイル名は `.env` とし、カレントフォルダに置いてください。
- 以下の6つの環境変数は必須です。

  <div style="background-color:rgba(240,255,255,0.05)">

  |環境変数|説明|
  |:--|:--|
  |GRDM_ACCESS_TOKEN|ユーザがGakuNin RDMで設定したパーソナルアクセストークン|
  |GRDM_OSFAPI_BASEURL|GakuNin RDMのOSF APIのベースURL|
  |GRDM_WBAPI_BASEURL|GakuNin RDMのWaterButler APIのベースURL|
  |GRDM_PROJECT_ID|GakuNin RDM上のプロジェクトID(5桁の英数字)|
  |GRDM_STORAGE_PROVIDER|ダウンロード/アップロード対象のデータが格納されるGakNin RDMのストレージ名|
  |GRDM_MOUNT_POINT|マウントポイント = ダウンロード/アプロード対象のデータが格納されるローカルのフォルダのパス|

  - 上記以外のパラメタについては、**[こちら](#Config詳細)** を参照してください。
  - `GRDM_STORAGE_PROVIDER` の値が不明の場合は、**[こちら](#ストレージプロバイダ名)** を参照してください。
  - `GRDM_MOUNT_POINT` は、実行時のオプションでマウントポイントを指定する場合に限り不要です。
  - Windowsの場合、パス中のバックスラッシュ("\\")はダブルバックスラッシュ("\\\\")としてください。
  - 何らかの理由で `.env` が作成できない場合は、任意のファイルに作成し、そのパスをコマンド実行時の引数で指定してください。
  
  </div>

<br>

## **ダウンローダー：GakuNin RDMストレージからローカルへのデータダウンロード**

以下のようにPythonスクリプト `grdm_stordl.py` を実行します。
```shell
> python grdm_stordl.py {Configファイルパス} -mp {マウントポイント} -y
```
&nbsp;<span style="background-color:#3cb371">注意</span>
- `grdm_stordl.py` が格納されるフォルダ以外で実行する場合は、`grdm_stordl.py` までのパスで指定してください。
- Configファイルパスは省略できます。その場合は、カレントフォルダの `.env` が読まれます（無い場合は `grdm_stordl.py` が格納されるフォルダの `.env` が読まれます）。それ以外のConfigファイルを使う場合は、そのパスを指定してください。
- `-mp` オプションでマウントポイントを指定した場合は、Configファイル(`.env` など)での `GRDM_MOUNT_POINT` の設定より優先されます。
- マウントポイントのフォルダは事前に作成してください。また、フォルダ内が空でない場合はダウンロードしません。
- `-y` オプションを指定すると、処理を進めるかどうかの確認をスキップしてアップロード処理が行われます。このオプションは、Configファイル(`.env` など)での `GRDM_INTERACTIVE_FLAG` の設定よりも優先されます。

<br>

実行後、以下のようにダウンロードの概要が標準出力に表示されます。確認の上、問題がなければ **yes** を入力してダウンロード処理を進めてください。
```
--------------------------------------------------------------------------
Data files will be downloaded from GakuNin RDM storage.
  GakuNin RDM project ID       : xyz01
  From (Remote storage folder) : /osfstorage/
  To (Local folder)            : /home/user/mnt_dir
--------------------------------------------------------------------------
Do you really want to proceed? [yes/no]
```

<br>

## **アップローダー：ローカルからGakuNin RDMストレージへのデータップロード**

以下のようにPythonスクリプト `grdm_storul.py` を実行します。
```shell
> python grdm_storul.py {Configファイルパス} -mp {マウントポイント} -y
```
&nbsp;<span style="background-color:#3cb371">注意</span>
- `grdm_storul.py` が格納されるフォルダ以外で実行する場合は、`grdm_storul.py` までのパスで指定してください。
- Configファイルパスは省略できます。その場合は、カレントフォルダの `.env` が読まれます（無い場合は `grdm_stordl.py` が格納されるフォルダの `.env` が読まれます）。それ以外のConfigファイルを使う場合は、そのパスを指定してください。
- `-mp` オプションでマウントポイントを指定した場合は、Configファイル(`.env` 等)での `GRDM_MOUNT_POINT` の設定より優先されます。
- `-y` オプションを指定すると、ユーザによる処理の継続/中断の確認をスキップしてアップロード処理が行われます。このオプションは、Configファイル(`.env` 等)での `GRDM_INTERACTIVE_FLAG` の設定よりも優先されます。

<br>

実行後、以下のようにアップロードの概要が標準出力に表示されます。確認の上、問題がなければ **yes** を入力してアップロード処理を進めてください。
```
--------------------------------------------------------------------------
Data files will be uploaded to GakuNin RDM storage.
  GakuNin RDM project ID     : xyz01
  From (Local folder)        : /home/user/mnt_dir
  To (Remote storage folder) : /osfstorage/20241231_235959
  * Note: A new remote folder will be created and local files will uploaded there. [GRDM_UPLOAD_REPLACE_FLAG=0]
  * Note: Local files will be kept after uploading. [GRDM_LOCAL_DELETE_FLAG=FALSE]
--------------------------------------------------------------------------
Do you really want to proceed? [yes/no]
```
&nbsp;<span style="background-color:#3cb371">注意</span>
- フラグについては **[こちら](#Config詳細)** を参照してください。
- デフォルトでは、アップロード先のフォルダ(ターゲットフォルダ)を上書きせず、ターゲットフォルダ以下に新規フォルダ(※フォルダ名はアップロード時の日付と時刻から；例えば"20241231_235959")を作成し、そこにデータをアップロードします。上書きしたい場合は、`GRDM_UPLOAD_REPLACE_FLAG` の値を1か2に設定してください。ただし、1の場合、内容が同じでも上書きしてしまう(更新時刻等が変わる)ので注意が必要です。
- ローカルの環境にあるデータはGakuNinRDMのストレージへのアップロード後も削除されることはありません。もし、アップロード後に自動的に削除したい場合は、`GRDM_LOCAL_DELETE_FLAG` の値をTRUEに設定してください。

<br>

## **付録**

<a id="Config詳細"></a>
### <u>Configファイルと設定パラメタについて</u>

Configファイルは、ユーザごとの設定を記述するためのファイルです。基本的には、カレントフォルダの `.env` ファイルに環境変数として設定します。設定の優先順位は以下の通りです(1 > 2 > 3)。

1. コマンド実行時の引数で指定されたファイル中の設定
2. `.env` ファイル中の設定
3. OSの環境変数設定
- `.env` ファイルは、カレントフォルダに無ければ、実行するPythonスクリプトが格納されるフォルダの `.env` を探します。
- 本ソフトウェアでは、JSON形式のファイルでも設定できます。その場合はファイル名の拡張子を「.json」とし、コマンド実行時の引数でファイルパスを指定してください。また、キーは大文字ではなく小文字で記述してください。

本ソフトウェアで設定できるパラメタは以下の通りです。なお、一部のパラメタは設定を共有する別ソフトウェア(GakuNin RDMストレージマウンター)でのみ利用され、本ソフトウェアでは利用されません。
<div style="background-color:rgba(240,255,255,0.05)">

  |パラメタ(環境変数)|型|説明|
  |:--|:--|:--|
  |GRDM_ACCESS_TOKEN|str|ユーザがGakuNin RDMで設定したパーソナルアクセストークン|
  |GRDM_OSFAPI_BASEURL|str|GakuNin RDMのOSF APIのベースURL|
  |GRDM_WBAPI_BASEURL|str|GakuNin RDMのWaterButler APIのベースURL|
  |GRDM_PROJECT_ID|str|GakuNin RDM上のプロジェクトID(5桁の英数字)|
  |GRDM_STORAGE_PROVIDER|str|ダウンロード/アップロード対象のデータが格納されるGakNin RDMのストレージ名|
  |GRDM_MOUNT_POINT|str|マウントポイント = ダウンロード/アプロード対象のデータが格納されるローカルのフォルダのパス|
  |GRDM_TARGET_FOLDER|str|ダウンロード/アップロード対象のデータが格納されるGakNin RDMのストレージ内のフォルダのパス [default="/" (ストレージのトップ)]|
  |GRDM_UPLOAD_CONCURRENT|int|データアップロード時の同時処理数 [default=10]|
  |GRDM_UPLOAD_REPLACE_FLAG|bool|データアップロード時にGakuNin RDMのストレージにある元データを上書きするかどうかのフラグ（0:上書きしない / 1:すべて上書きする / 2:ダウンロードしたものから更新・追加分のみ上書きする） [default=0 (上書きしない)]|
  |GRDM_LOCAL_DELETE_FLAG|bool|データアップロード後にローカルのデータを削除するかどうかのフラグ [default=FALSE (削除しない)]|
  |GRDM_INTERACTIVE_FLAG|bool|処理の継続/中断をインタラクティブに確認するかどうかのフラグ（確認しない場合は、**yes** が入力されたものとする） [defaul=TRUE (確認する)]|
  |GRDM_OUT_LOG|str|(※本ソフトウェアでは利用しない) コマンドのログの出力ファイルのパス|

  - `GRDM_TARGET_FOLDER` はストレージのトップ("/")を含む絶対パスで指定してください。
  - `GRDM_UPLOAD_REPLACE_FLAG` が0の場合は、アップロード先のフォルダ(ターゲットフォルダ)以下に新規フォルダ(※フォルダ名はアップロード時の日付と時刻から；例えば"20241231_235959")を作成し、そこにデータをアップロードします。
  - `GRDM_UPLOAD_REPLACE_FLAG` が2の場合は、マウントポイントをダウンロード時と同一に設定してください。(※ダウンロード時にマウントポイントに作られるリストを利用します)
  - default値が記載されていないパラメタが設定されない場合は、本ソフトウェアでは `None` として扱われ、処理がエラーになります。(※ `GRDM_OUT_LOG` は設定されなくても処理はエラーになりません)
  
  </div>

<br>

<a id="ストレージプロバイダ名"></a>
### <u>ストレージプロバイダ名について</u>

`GRDM_STORAGE_PROVIDER` で指定する値(ストレージプロバイダ名)が不明な場合は、本ソフトウェアのパッケージに同梱してあるPythonスクリプト `grdm_storls.py` を以下のように実行してください。その実行結果として、`GRDM_PROJECT_ID` で指定するGakuNin RDMのプロジェクトにマウントされているストレージ名のリストが表示されますので、該当するものを選んで ダウンローダー/アップローダーの `GRDM_STORAGE_PROVIDER` に指定してください。
```shell
> python grdm_storls.py {Configファイルパス} -p {プロジェクトID}
```
&nbsp;<span style="background-color:#3cb371">注意</span>
- `grdm_storls.py` が格納されるフォルダ以外で実行する場合は、`grdm_storls.py` までのパスで指定してください。
- ここで設定が必要なConfigパラメタは、`GRDM_ACCESS_TOKEN`、`GRDM_OSFAPI_BASEURL` 、および `GRDM_PROJECT_ID` の3つだけです。
- Configファイルパスは省略できます。その場合は、カレントフォルダの `.env` が読まれます（無い場合は `grdm_stordl.py` が格納されるフォルダの `.env` が読まれます）。それ以外のConfigファイルを使う場合は、そのパスを指定してください。
- `-p` オプションでプロジェクトIDを指定した場合は、Configファイル(`.env`含む)での設定より優先されます。

