# grdm_stordlの入り口
#
# 改訂履歴：
# 2024-07-10 H.Hayashi : Poetry利用版の__main__から移植
# 2025-09-12 H.Hayashi : 非インタラクティブモードフラグ(no_interact)を導入

import signal
import sys

#from grdm_stordl import downloader  # <- Poetry利用版 
#from . import downloader  # <- これはエラー..
import downloader

message = None

# シグナル処理関数
def sig_handler(signum, frame) -> None:

    global message

    # シグナル別のメッセージ定義
    if signum == signal.SIGINT:  # Ctrl-C
        sig_str = '"SIGINT" signal'
        message = 'Aborted. (SIGINT)'
    elif signum == signal.SIGTERM:  # killコマンド
        sig_str = '"SIGTERM" signal'
        message = 'Aborted. (SIGTERM)'
    else:  # これは起こらないはず
        sig_str = '"Some signal (num={signum})"'
        message = f'Aborted. (Signal #: {signum})'

    # 標準出力にメッセージ出力
    print(f'{sig_str} caught; Process aborted.')

    # 終了(終了の前にfinallyが実行される)
    status_code = 128 + signum  # 128 + シグナル番号
    sys.exit(status_code)

def main() -> None:

    global message

    # シグナルトラップ
    signal.signal(signal.SIGTERM, sig_handler)
    signal.signal(signal.SIGINT,  sig_handler)

    # 処理実行
    no_interact = False  # エラー時の対応のため初期値をFalseとする
    try:
        (rc, no_interact) = downloader.download()
        if rc == 0:
            message = 'Completed.'
        else:
            if rc == 100:  # コマンド引数不正 or 「-h/--help」指定時はここではメッセージを出さない
                pass
            else:
                message = f'Aborted. (rc={rc})'
            sys.exit(1)
    except Exception as e:
        print(f'UNEXPECTED ERROR : {e}')
        message = 'Aborted.'
        sys.exit(1)
    finally:
        # メッセージ出力の前にkillコマンドやCntl-Cで終了しないように
        signal.signal(signal.SIGTERM, signal.SIG_IGN)
        signal.signal(signal.SIGINT,  signal.SIG_IGN)
        if message:
            print(message)
        else:
            pass
        # 元に戻す
        signal.signal(signal.SIGTERM, signal.SIG_DFL)
        signal.signal(signal.SIGINT,  signal.SIG_DFL)
        # インタラクティブモードの場合は、ユーザに終了してもらう
        if not no_interact:
            input("Press Any Key to Exit")  # exe化しない場合はコメントアウト
            #pass  # exe化する場合はコメントアウト
        else:
            pass

if __name__ == "__main__":
    main()
