# create_grdmprjの入力パラメタを取得する関数
#
# 改訂履歴：
# 2023-10-22 H.Hayashi : 初版作成(v0.0.2より導入)
# 2025-08-01 H.Hayashi : --rikenオプション追加
# 2025-09-04 H.Hayashi : --rikenオプション削除(※環境変数に変更)

import pandas
import argparse
import os
import sys

class getInput():

    # 実行時引数の取得
    def parseArg(self):
        
        parser = argparse.ArgumentParser(prog='python -m create_grdmprj', usage='%(prog)s [options]')

        # 必須引数(※なくてもエラーにならないようにdefault値を設定)
        parser.add_argument('parent_id', nargs='?', type=str, default=None,
                            #help="parent project's ID")  # 第1引数
                            help=argparse.SUPPRESS)
        parser.add_argument('prj_title', nargs='?', type=str, default=None,
                            #help="title of project to be created")  # 第2引数
                            help=argparse.SUPPRESS)

        # オプション引数(-f "filepath" / --file "filepath")
        parser.add_argument('-f', '--file', type=str, metavar='FILEPATH',
                            help='specify path to a CSV file which includes parent ID(s) and project title(s)')
        ## オプション引数(--riken)
        #parser.add_argument('--riken', action='store_true', help=argparse.SUPPRESS)

        # 引数の取得(「-h/--help」が指定されたときはヘルプを表示して終了)
        args = parser.parse_args()
        
        return args

    # CSVファイルからの読み込み
    def readCSVFile(self, filepath):
        
        df = pandas.read_csv(filepath, encoding="utf-8", dtype=str, comment='#', header=None, 
                             skipinitialspace=True)
        
        # NaN -> Noneに変換
        df = df.where(df.notna(), None)
        
        # list型の配列に格納
        vals = df.values.tolist()
        
        return vals
        
gi = getInput()

PARENT_ID = gi.parseArg().parent_id
PRJ_TITLE = gi.parseArg().prj_title
INPUTFILE = gi.parseArg().file
#RIKENGRDM = gi.parseArg().riken

# -fオプションでファイルが指定されている場合はファイルから読み取る
if INPUTFILE:
    
    # ファイルの存在確認
    if not os.path.isfile(INPUTFILE):
        print(f'"{INPUTFILE}" not found.')
        sys.exit(-1)
    else:
        pass
    
    # ファイルのアクセス確認
    if not os.access(INPUTFILE, os.R_OK):
        print(f'"{INPUTFILE}" not readable.')
        sys.exit(-2)
    else:
        pass
    
    INPUTS = gi.readCSVFile(INPUTFILE)

# -fオプションが無い場合は、引数から読み取る    
else:
    
    INPUTS = [[PARENT_ID, PRJ_TITLE]]
