# create_grdmprjのメインプログラム
#
# 改訂履歴：
# 2023-10-27 H.Hayashi : 初期版作成
# 2023-11-22 H.Hayashi : 作成ノードのカテゴリを"data"に変更；RIH Maintainerの権限を"admin"に変更；
#                        呼び出し元に辞書型のリストで情報を返すように変更；エラーメッセージの出力を中止
# 2023-11-24 H.hayashi : リターンコードやメッセージを呼び出し元に返すリストに含めるように変更；
#                        関数init_summaryとfin_summaryを作成
# 2025-08-01 H.Hayashi : RIKENGRDMオプションの導入；直上の親とrootの親の両方をsummaryに出力するよう変更
# 2025-09-04 H.Hayashi : RIKENGRDMオプション(コマンドオプションより) -> RIKEN_FLAG(環境変数より)
# 2025-09-22 H.Hayashi : 非Poetry版(importの変更)

import requests
import datetime
import sys  #デバッグ等でsys.exit()を呼ぶときに使う

#from create_grdmprj.settings import OSFAPI, TOKEN, RIKEN_FLAG  # <- Poetry利用時
from .settings import OSFAPI, TOKEN, RIKEN_FLAG


def init_summary():
    
    # 現在時刻の取得
    ctime = datetime.datetime.now().astimezone().isoformat()
    
    # 出力データの初期化
    summary = {
        "internal_rc": 0,
        "message" : None,
        "start_date": ctime,
        "stop_date": None,
        "parent_guid": None,
        "root_guid": None,
        "guid_created": None,
        "url_created": None,
        "title_created": None,
        "creator_guid": None,
        "creator_name": None,
    }
    
    return summary

def fin_summary( summary, rc, msg ):
    
    # リターンコードとメッセージの格納
    summary["internal_rc"] = rc
    summary["message"] = msg
    
    # 現在時刻の取得
    ctime = datetime.datetime.now().astimezone().isoformat()
    summary["stop_date"] = ctime
    
    return

def create_grdmprj( parent_prj, title ):

    #sys.exit()
    #return None
    
    # 出力データの初期化
    summary = init_summary()

    # 入力パラメタが文字列で"None"や"Null"の場合は、Noneに変換
    if parent_prj:
        if parent_prj.lower() == "none" or parent_prj.lower() == "null":
            parent_prj = None
        else:
            pass
    if title:
        if title.lower() == "none" or title.lower() == "null" or title.lower() == "nan":
            title = None
        else:
            pass
        
    # プロジェクトタイトルがNULLの場合は、エラーとする
    if not title:
        rc = 101
        msg = 'Project title not given.'
        fin_summary( summary, rc, msg )
        return summary
    else:
        pass
    
    # RIKEN_FLAGがTrueの場合は、プロジェクトのカテゴリーを"data"とする
    if RIKEN_FLAG:
        category = 'data'
    else:
        category = 'project'  # GRDMのGUIで新規作成すると"project"になる
    
    # 親プロジェクトがNULLの場合は、親プロジェクトを作成する
    if not parent_prj:

        headers = {
            'Content-Type': 'application/json',
            'Authorization': 'Bearer {}'.format(TOKEN),
        }

        json_data = {
            'data': {
                'type': 'nodes',
                'attributes': {
                    'title': title,
                    'category': category,
                },
            },
        }

        api_url = OSFAPI.rstrip('/') + '/nodes/'
        response = requests.post(api_url, headers=headers, json=json_data)
        if response.status_code != requests.codes.created:
            rc = 102
            msg = 'Failed to create parent node.'
            fin_summary( summary, rc, msg )
            return summary
        else:
            pass

        # プロジェクトのID等の取得
        py_res = response.json()
        id_prj  = py_res["data"]["id"]  # 作成プロジェクトID
        url_prj = py_res["data"]["links"]["html"]  # 作成プロジェクトURL
        ttl_prj = py_res["data"]["attributes"]["title"]  # 作成プロジェクトタイトル
        id_root = py_res["data"]["relationships"]["root"]["data"]["id"]  # ルートプロジェクトID
        href_cr = py_res["data"]["relationships"]["creator"]["links"]["related"]["href"]  # 作成者情報先
        
        # 出力としては、ルート、親プロジェクトIDともNULLにする
        if id_root == id_prj:
            id_root = None
            id_pare = None  # レスポンスに含まれないが、サマリの出力としてはNoneにする
        else:
            pass  # <- これはあり得ない
        
    # 親プロジェクトがNULLでなければ、子プロジェクトを作成する
    else:

        # 親プロジェクトの存在をチェック
        headers = {
            'Authorization': 'Bearer {}'.format(TOKEN),
        }

        api_url = OSFAPI.rstrip('/') + '/nodes/'
        response = requests.get(api_url, headers=headers)
        if response.status_code != requests.codes.ok:
            rc = 103
            msg = 'Failed to retrieve list of all nodes.'
            fin_summary( summary, rc, msg )
            return summary
        else:
            pass

        #parent_exist = False
        #py_res = response.json()
        #data_res = py_res["data"]   # <- dataの要素取得
        #for data in data_res:
        #    id = data["id"]         # <- idの値を取得
        #    if id == parent_prj:
        #        parent_exist = True
        #    else:
        #        pass
        
        parent_exist = False
        page = 1
        while True:
            py_res = response.json()
            data_res = py_res["data"]   # <- dataの要素取得
            link_nxt = py_res["links"]["next"]  # <- 次ページのリンク取得
            for data in data_res:
                id = data["id"]  # <- idの値を取得
                if id == parent_prj:
                    parent_exist = True
                    break
                else:
                    pass
            if parent_exist:
                break
            else:
                if link_nxt:
                    page += 1
                    #response = requests.get(link_nxt, headers=headers)  # 次のページに移動 <- 次ページリンクのURLになぜかポート番号が含まれていない..
                    link_nxt_true = api_url + '?page=' + str(page)  # どこのサーバでもこれでよいかは不明
                    ## check
                    #print('url of next page (returned) = ', link_nxt)
                    #print('url of next page (guessed)  = ', link_nxt_true)
                    response = requests.get(link_nxt_true, headers=headers)  # 次のページに移動
                    if response.status_code != requests.codes.ok:
                        rc = 104
                        msg = f'Failed to retrieve list of all nodes. (Page={page}) [HTTP status code = {response.status_code}]'
                        fin_summary( summary, rc, msg )
                        return summary
                    else:
                        pass
                    continue
                else:
                    break  # これ以上ページがない
        
        if not parent_exist:
            rc = 105
            msg = 'Parent node (id='+parent_prj+') not found.'
            fin_summary( summary, rc, msg )
            return summary
        else:
            pass
        
        # DEBUG
        #sys.exit()

        # 子プロジェクトの作成
        headers = {
            'Content-Type': 'application/json',
            'Authorization': 'Bearer {}'.format(TOKEN),
        }

        json_data = {
            'data': {
                'type': 'nodes',
                'attributes': {
                    'title': title,
                    'category': category,
                },
            },
        }

        api_url = OSFAPI.rstrip('/') + '/nodes/' + parent_prj + '/children/'
        response = requests.post(api_url, headers=headers, json=json_data)
        if response.status_code != requests.codes.created:
            rc = 106
            msg = 'Failed to create child node.'
            fin_summary( summary, rc, msg )
            return summary
        else:
            pass

        # プロジェクトのID等の取得
        py_res = response.json()
        id_prj  = py_res["data"]["id"]  # 作成プロジェクトID
        url_prj = py_res["data"]["links"]["html"]  # 作成プロジェクトURL
        ttl_prj = py_res["data"]["attributes"]["title"]  # 作成プロジェクトタイトル
        id_root = py_res["data"]["relationships"]["root"]["data"]["id"]  # ルートプロジェクトID
        id_pare = py_res["data"]["relationships"]["parent"]["data"]["id"]  # 親プロジェクトID
        href_cr = py_res["data"]["relationships"]["creator"]["links"]["related"]["href"]  # 作成者情報先
    
    # (以下は親/子プロジェクト共通)
    
    # 出力データの更新
    summary["parent_guid"]   = id_pare
    summary["root_guid"]     = id_root
    summary["guid_created"]  = id_prj
    summary["url_created"]   = url_prj
    summary["title_created"] = ttl_prj

    # プロジェクト作成者の情報を取得する
    headers = {
        'Authorization': 'Bearer {}'.format(TOKEN),
    }

    api_url = href_cr
    response = requests.get(api_url, headers=headers)
    if response.status_code != requests.codes.ok:
        rc = 107
        msg = 'Failed to retrieve user info.'
        fin_summary( summary, rc, msg )
        return summary
    else:
        pass
    
    py_res = response.json()
    id_cr   = py_res["data"]["id"]  # プロジェクト作成者ID
    name_cr = py_res["data"]["attributes"]["full_name"]  # プロジェクト作成者名

    # 出力データの更新
    summary["creator_guid"] = id_cr
    summary['creator_name'] = name_cr
    
    # [RIKEN_FLAGがTrueの場合のみ]作成したプロジェクトのContributorにRIH Maintainerを追加する
    if RIKEN_FLAG:
                
        headers = {
            'Content-Type': 'application/json',
            'Authorization': 'Bearer {}'.format(TOKEN),
        }

        json_data = {
            'data': {
                'type': 'contributors',
                'attributes': {
                    'permission': 'admin',
                },
                'relationships': {
                    'user': {
                        'data': {
                            'type': 'users',
                            'id': 'g37b6',   # <- RIH MaintainerのID
                        },
                    },
                },
            },
        }

        api_url = OSFAPI.rstrip('/') + '/nodes/' + id_prj + '/contributors/'
        response = requests.post(api_url, headers=headers, json=json_data)
        if response.status_code != requests.codes.created:
            rc = 108
            msg = 'Failed to add contributor (RIH Maintainer).'
            fin_summary( summary, rc, msg )
            return summary
        else:
            pass

    else:

        pass
    

    # 正常終了
    rc = 0
    msg = 'Completed.'
    fin_summary( summary, rc, msg )
    return summary
