# create_grdmprj用の設定
#
#   - 環境変数から取得する
#
# 改訂履歴：
# 2023-10-xx H.Hayashi : 初期版作成
# 2025-09-04 H.Hayashi : 理研フラグ導入(初期値=False)；OSFAPIのデフォルトはNIIのGRDMに変更

from pydantic_settings import BaseSettings


class Settings(BaseSettings):
    create_grdmprj_token: str = "secret"
    create_grdmprj_osfapi: str = "https://api.rdm.nii.ac.jp/v2/"
    create_grdmprj_riken: bool = False
    
    class Config:
        env_file = ".env"
        env_file_encoding = "utf-8"


settings = Settings()

TOKEN = settings.create_grdmprj_token
OSFAPI = settings.create_grdmprj_osfapi
RIKEN_FLAG = settings.create_grdmprj_riken
