# r2dms_uploader用の設定
#
#   - 環境変数から取得
#
# 改訂履歴:
# 2024-01-xx H.Hayashi : 初版作成
# 2025-09-05 H,Hayashi : 一般化対応(理研用環境変数追加、等)

import os
from typing import Optional

from pydantic_settings import BaseSettings

class Settings(BaseSettings):
    
    # 全体制御ツール用
    #grdm_token: str = "secret"
    #dmsutil_token: str = "secret"
    grdm_token: Optional[str] = None
    grdm_osfapi: Optional[str] = None
    grdm_wbapi: Optional[str] = None
    grdm_riken: Optional[bool] = None
    dmsutil_token: Optional[str] = None
    # 以下は将来的に必要になるかも(各ツールが全体制御から独立して存在するケース)
    #create_grdmprj_path: str = None
    #r2dms_dmsutil_path: str = None
    #wbclient_path: str = None

    # 各ツール用
    create_grdmprj_token: str = "secret"
    create_grdmprj_osfapi: str = "https://api.rdm.nii.ac.jp/v2"
    create_grdmprj_riken: bool = False
    r2dms_dmsutil_token: str = "secret"
    wbclient_entry_point: str = "https://files.rdm.nii.ac.jp"
    wbclient_token: str = "secret"
    wbclient_remote_path: str = "/"  # 全体制御ツール用に追加
    wbclient_storage_provider: str = "osfstorage"
    wbclient_concurrent: int = 10
    
    class Config:
        env_file = ".env_control"
        env_file_encoding = "utf-8"
        extra = "ignore"

settings = Settings()
## check
#print(f'[check:Settings] grdm_token = {settings.grdm_token}')
#print(f'[check:Settings] grdm_osfapi = {settings.grdm_osfapi}')
#print(f'[check:Settings] grdm_wbapi = {settings.grdm_wbapi}')
#print(f'[check:Settings] grdm_riken = {settings.grdm_riken}')
#print(f'[check:Settings] dmsutil_token = {settings.dmsutil_token}')
#print(f'[check:Settings] create_grdmprj_token = {settings.create_grdmprj_token}')
#print(f'[check:Settings] create_grdmprj_osfapi = {settings.create_grdmprj_osfapi}')
#print(f'[check:Settings] create_grdmprj_riken = {settings.create_grdmprj_riken}')
#print(f'[check:Settings] r2dms_dmsutil_token = {settings.r2dms_dmsutil_token}')
#print(f'[check:Settings] wbclient_entry_point = {settings.wbclient_entry_point}')
#print(f'[check:Settings] wbclient_token = {settings.wbclient_token}')
#print(f'[check:Settings] wbclient_remote_path = {settings.wbclient_remote_path}')
#print(f'[check:Settings] wbclient_storage_provider = {settings.wbclient_storage_provider}')
#print(f'[check:Settings] wbclient_concurrent = {settings.wbclient_concurrent}')

# トークン等の取得
GRDM_TOKEN = settings.grdm_token
GRDM_OSFAPI = settings.grdm_osfapi
GRDM_WBAPI = settings.grdm_wbapi
GRDM_RIKEN = settings.grdm_riken
DMSUTIL_TOKEN = settings.dmsutil_token

# 各ツール向け環境変数の設定(.envファイルがあっても、各ツールではここで設定した環境変数が優先される)
if GRDM_RIKEN:
    os.environ["CREATE_GRDMPRJ_RIKEN"] = str(GRDM_RIKEN)
else:
    os.environ["CREATE_GRDMPRJ_RIKEN"] = str(settings.create_grdmprj_riken)
if GRDM_TOKEN:
    os.environ["CREATE_GRDMPRJ_TOKEN"] = GRDM_TOKEN
else:
    os.environ["CREATE_GRDMPRJ_TOKEN"] = settings.create_grdmprj_token
if GRDM_OSFAPI:
    os.environ["CREATE_GRDMPRJ_OSFAPI"] = GRDM_OSFAPI
else:
    if GRDM_RIKEN:
        os.environ["CREATE_GRDMPRJ_OSFAPI"] = "https://dmsgrdm.riken.jp:8000/v2"
    else:
        os.environ["CREATE_GRDMPRJ_OSFAPI"] = settings.create_grdmprj_osfapi
if DMSUTIL_TOKEN:
    os.environ["R2DMS_DMSUTIL_TOKEN"] = DMSUTIL_TOKEN
else:
    os.environ["R2DMS_DMSUTIL_TOKEN"] = settings.r2dms_dmsutil_token
if GRDM_WBAPI:
    os.environ["WBCLIENT_ENTRY_POINT"] = GRDM_WBAPI
else:
    if GRDM_RIKEN:
        os.environ["WBCLIENT_ENTRY_POINT"] = "https://dmsgrdm.riken.jp:7777"
    else:
        os.environ["WBCLIENT_ENTRY_POINT"] = settings.wbclient_entry_point
if GRDM_TOKEN:
    os.environ["WBCLIENT_TOKEN"] = GRDM_TOKEN
else:
    os.environ["WBCLIENT_TOKEN"] = settings.wbclient_token
os.environ["WBCLIENT_REMOTE_PATH"] = settings.wbclient_remote_path
if GRDM_RIKEN:
    os.environ["WBCLIENT_STORAGE_PROVIDER"] = "s3compatriken"
else:
    os.environ["WBCLIENT_STORAGE_PROVIDER"] = settings.wbclient_storage_provider
os.environ["WBCLIENT_CONCURRENT"] = str(settings.wbclient_concurrent)  # 文字型でないとエラーになる       
## check
#print(f'[check:Settings] CREATE_GRDMPRJ_TOKEN = {os.environ.get("CREATE_GRDMPRJ_TOKEN")}')
#print(f'[check:Settings] CREATE_GRDMPRJ_OSFAPI = {os.environ.get("CREATE_GRDMPRJ_OSFAPI")}')
#print(f'[check:Settings] CREATE_GRDMPRJ_RIKEN = {os.environ.get("CREATE_GRDMPRJ_RIKEN")}')
#print(f'[check:Settings] R2DMS_DMSUTIL_TOKEN = {os.environ.get("R2DMS_DMSUTIL_TOKEN")}')
#print(f'[check:Settings] WBCLIENT_ENTRY_POINT = {os.environ.get("WBCLIENT_ENTRY_POINT")}')
#print(f'[check:Settings] WBCLIENT_TOKEN = {os.environ.get("WBCLIENT_TOKEN")}')
#print(f'[check:Settings] WBCLIENT_REMOTE_PATH = {os.environ.get("WBCLIENT_REMOTE_PATH")}')
#print(f'[check:Settings] WBCLIENT_STORAGE_PROVIDER = {os.environ.get("WBCLIENT_STORAGE_PROVIDER")}')
#print(f'[check:Settings] WBCLIENT_CONCURRENT = {os.environ.get("WBCLIENT_CONCURRENT")}')
        