# This is an alternative version for being used under r2dms_uploader
import json
import sys

from wbclient.exceptions import WBClientException
from wbclient.upload import UploadCommand

def main() -> None:
    command = UploadCommand()
    project_id = sys.argv[1]
    local_path = sys.argv[2]
    replace_flag = sys.argv[3]
    remote_path = "/"

    try:
        res = command.upload(project_id, local_path, int(replace_flag), remote_path)
        result = {'update_result': res}
        print(json.dumps(result, ensure_ascii=False))
    except WBClientException as e:
        print(f"Error: {e}")
        sys.exit(2)
    except KeyboardInterrupt:
        sys.exit(130)


if __name__ == "__main__":
    main()
