class WBClientException(Exception):
    """Thrown when some kind of errors occurred"""

    pass


class IllegalArgumentException(WBClientException):
    """Thrown when something wrong with the argument is passed to a method"""

    pass


class MissingConfigurationException(WBClientException):
    """Thrown when wrong or missing system configuration"""

    pass


class BadRequestException(WBClientException):
    """Thrown when the request does not contain valid parameter"""

    pass


class UnauthorizedException(WBClientException):
    """Thrown when the current user not allowed to perform an operation on the resource"""

    pass


class ForbiddenException(WBClientException):
    """Thrown when the current user does not have enough privileges to access the resource"""

    pass


class UnexpectedException(WBClientException):
    """Thrown when unexpected error occurred"""

    pass
