from pydantic_settings import BaseSettings


class Settings(BaseSettings):
    wbclient_entry_point: str = "https://dmsgrdm.riken.jp:7777"
    wbclient_token: str = "secret"
    wbclient_storage_provider: str = "s3compatriken"
    wbclient_concurrent: int = 10

    class Config:
        env_file = ".env"
        env_file_encoding = "utf-8"


settings = Settings()

CONCURRENT = settings.wbclient_concurrent
ENTRY_POINT = settings.wbclient_entry_point
TOKEN = settings.wbclient_token
STORAGE_PROVIDER = settings.wbclient_storage_provider
            