# This is an alternative version for import by r2dms_uploader (with some bugfixes)
#
# 改訂履歴：
# 2025-09-05 H.Hayashi : アップロード結果のsummaryへの出力を変更(osfstorageの場合パスではなくidになるので)
# 2025-09-22 H.Hayashi : 非Poetry版(importの変更)

import os
import platform
from abc import ABC
from concurrent.futures import ThreadPoolExecutor
from typing import Any
from unicodedata import normalize

from pydantic.dataclasses import dataclass
#from requests import Session  # changed for import by r2dms_uploader
from requests import Session, codes

#from wbclient.exceptions import IllegalArgumentException, WBClientException  # changed for import by r2dms_uploader
#from wbclient.exceptions import IllegalArgumentException, BadRequestException, WBClientException  # poetry版
#from wbclient.settings import CONCURRENT, ENTRY_POINT, STORAGE_PROVIDER, TOKEN  # poetry版
from .exceptions import IllegalArgumentException, BadRequestException, WBClientException
from .settings import CONCURRENT, ENTRY_POINT, STORAGE_PROVIDER, TOKEN


@dataclass(frozen=True)
class UploadFileInfo:
    folder: Any
    path: str


class BaseCommand(ABC):
    session: Session

    def __init__(self):
        super().__init__()
        self.session = Session()
        self.session.headers.update(
            {
                "User-Agent": f"WbClient/0.0.1 (Python {platform.python_version()} - {platform.platform()})",
                "Accept": "application/json",
                "Authorization": f"Bearer {TOKEN}",
            }
        )


class UploadCommand(BaseCommand):
    def _query_get_info(self, project_id: str, id: str) -> Any:
        response = self.session.get(f"{ENTRY_POINT}/v1/resources/{project_id}/providers/{id}?meta=")
        # TODO: error handling
        if response.status_code != codes.ok:  # added for import by r2dms_uploader
            raise BadRequestException(f"API error in `_query_get_info`.")
        return {"id": f"{id}", "entries": response.json()["data"]}

    def _query_create_subfolder(self, project_id: str, folder_id: str, name: str) -> Any:
        response = self.session.put(
            f"{ENTRY_POINT}/v1/resources/{project_id}/providers/{folder_id}?kind=folder&name={name}"
        )
        # TODO: error handling
        if response.status_code != codes.created:  # added for import by r2dms_uploader
            raise BadRequestException(f"API error in `_query_create_subfolder`.")
        return response.json()["data"]

    def _query_file_upload(self, project_id: str, folder_id: str, path: str, name: str):
        with open(path, mode="rb") as fp:
            response = self.session.put(
                f"{ENTRY_POINT}/v1/resources/{project_id}/providers/{folder_id}?kind=file&name={name}",
                #files={"file": fp},   # Bugfix 2023.12.21
                data=fp,
            )
        # TODO: error handling
        if response.status_code != codes.created:  # added for import by r2dms_uploader
            raise BadRequestException(f"API error in `_query_file_upload`.")
        return response.json()

    def _query_file_replace(self, project_id: str, file_id: str, path: str):
        # added for import by r2dms_uploader
        with open(path, mode="rb") as fp:
            response = self.session.put(
                f"{ENTRY_POINT}/v1/resources/{project_id}/providers/{file_id}?kind=file",
                data=fp,
            )
        # TODO: error handling
        if response.status_code != codes.ok:  # added for import by r2dms_uploader
            raise BadRequestException(f"API error in `_query_file_replace`.")
        return response.json()

    def _find_subfolder(self, folder: Any, name: str):
        for entry in folder["entries"]:
            if entry["attributes"]["kind"] == "folder" and entry["attributes"]["name"] == name:
                return entry
        return None

    def _find_file(self, folder: Any, name: str):
        for entry in folder["entries"]:
            if entry["attributes"]["kind"] == "file" and entry["attributes"]["name"] == name:
                return entry
        return None

    def _append_subfolder(self, folder: Any, entry: Any):
        folder["entries"].append(entry)

    #def upload(self, project_id: str, local_path: str, replace_flag: str, remote_path: str) -> None:  # changed for import by r2dms_uploader
    def upload(self, project_id: str, local_path: str, replace_flag: int, remote_path: str) -> "dict[str, str]":
        l_path = os.path.realpath(local_path)
        r_path = f"{STORAGE_PROVIDER}{remote_path}"
        if not os.path.exists(l_path):
            raise IllegalArgumentException(f"File or directory `{local_path}` not found.")
        folder = self._query_get_info(project_id, normalize("NFC", r_path))
        infos: list[UploadFileInfo] = []
        sum_upload = list()  # summary of upload (added for import by r2dms_uploader) 
        if os.path.isdir(l_path):
            folder_map: dict[str, Any] = {}
            folder_map[r_path] = folder
            l_basename = os.path.basename(l_path)
            for dirpath, _, filenames in os.walk(l_path):
                sub = l_basename if dirpath == l_path else os.path.join(l_basename, os.path.relpath(dirpath, l_path))
                d_dirname = os.path.join(r_path, sub)
                d_basename = os.path.basename(d_dirname)
                # prepare destination parent path
                d_parent_dirname = os.path.dirname(d_dirname)
                if folder_map.get(d_parent_dirname + "/") is None:
                    folder_map[d_parent_dirname + "/"] = self._query_get_info(project_id, d_parent_dirname + "/")
                # prepare destination path
                if folder_map.get(d_dirname + "/") is None:
                    d_folder = self._find_subfolder(folder_map[d_parent_dirname + "/"], d_basename)
                    if d_folder is None:
                        d_folder = self._query_create_subfolder(
                            project_id, folder_map[d_parent_dirname + "/"]["id"], d_basename
                        )
                        self._append_subfolder(folder_map[d_parent_dirname + "/"], d_folder)
                        #sum_upload.append([d_folder["id"], "created."])  # added for import by r2dms_uploader
                        sum_upload.append([d_folder["attributes"]["provider"]+d_folder["attributes"]["materialized"], "created."])  # added for import by r2dms_uploader
                    else:
                        #sum_upload.append([d_folder["id"], "already exists."])  # added for import by r2dms_uploader
                        sum_upload.append([d_folder["attributes"]["provider"]+d_folder["attributes"]["materialized"], "already exists."])  # added for import by r2dms_uploader
                    #print(d_dirname)  # commented out for import by r2dms_uploader
                    folder_map[d_dirname + "/"] = self._query_get_info(project_id, d_folder["id"])
                # register upload file list
                for filename in filenames:
                    infos.append(UploadFileInfo(folder_map[d_dirname + "/"], os.path.join(dirpath, filename)))
        else:
            infos.append(UploadFileInfo(folder, l_path))
        #self.__multiple_upload(project_id, infos)  # changed for import by r2dms_uploader
        res = self.__multiple_upload(project_id, replace_flag, infos)
        sum_upload = sum_upload + list(res)  # directory creation + file upload (added for import by r2dms_uploader)
        return dict(sum_upload)  # added for import by r2dms_uploader
        
    #def __multiple_upload(self, project_id: str, infos: list[UploadFileInfo]) -> None:  # Bugfix?
    def __multiple_upload(self, project_id: str, replace_flag: int, infos: "list[UploadFileInfo]") -> None:
        with ThreadPoolExecutor(max_workers=CONCURRENT) as pool:
            #pool.map(lambda x: self.__multiple_upload_worker(project_id, x), infos)  # changed for import by r2dms_uploader
            res = pool.map(lambda x: self.__multiple_upload_worker(project_id, replace_flag, x), infos)
            return res  # added for import by r2dms_uploader

    def __multiple_upload_worker(self, project_id: str, replace_flag: str, info: UploadFileInfo) -> None:
        basename = os.path.basename(info.path)
        file = self._find_file(info.folder, basename)
        try:
            if file is None:
                #self._query_file_upload(project_id, info.folder["id"], info.path, basename)
                res_upl = self._query_file_upload(project_id, info.folder["id"], info.path, basename)
                #res = [info.folder["id"] + basename, "uploaded."]  # added for import by r2dms_uploader
                res = [res_upl["data"]["attributes"]["provider"]+res_upl["data"]["attributes"]["materialized"], "uploaded."]  # added for import by r2dms_uploader
            # else:
            #     file_api.update(file, info.path)
            else:  # added for import by r2dms_uploader
                if replace_flag == 1:
                    self._query_file_replace(project_id, file["id"], info.path)
                    #res = [file["id"], "replaced."]
                    res = [file["attributes"]["provider"]+file["attributes"]["materialized"], "replaced."]
                else:  # must be "0"
                    #res = [file["id"], "found (not replaced)."]
                    res = [file["attributes"]["provider"]+file["attributes"]["materialized"], "found (not replaced)."]
            #print(info.folder["id"] + basename)  # commented out for import by r2dms_uploader
            return res  # added for import by r2dms_uploader
        except WBClientException as e:
            #print(f"API Error: {e}")  # commented out for import by r2dms_uploader
            res = [info.folder["id"] + basename, f"API error ({e})."]  # added for import by r2dms_uploader
            return res  # added for import by r2dms_uploader
